<?PHP
CLASS image{
    FUNCTION resize($IN='',$W='',$H='',$MARKER=false,$MARKER_WHERE,$degrees){
        IF(!$W || !$H){
            list($W, $H) = array('120','120');
        }
        list($WN, $HN, $TYPE) = getimagesize($IN);
        $SXY = round($WN / $HN, 3);
        IF($SXY < 1){
        //    $W = intval($H * $SXY);
        } ELSE {
        //    $H = intval($W / $SXY);
        }
        $DIR = dirname(__FILE__);
        SWITCH ($TYPE) {
            CASE(1):
            $OLD = imagecreatefromgif($IN);
            BREAK;
            CASE(2):
            $OLD = imagecreatefromjpeg($IN);
            BREAK;
            CASE(3):
            $OLD = imagecreatefrompng($IN);
            BREAK;
            DEFAULT:
            return;
            BREAK;
        }
        $NEW = imagecreatetruecolor($W, $H);
        imagecopyresampled($NEW, $OLD, 0, 0, 0, 0, $W, $H, $WN, $HN);
        IF($MARKER!=FALSE){
            $NEW = image::marker($NEW, imagecreatefrompng($MARKER), $MARKER_WHERE);
        }
        //$IMG = imagegif($NEW, $OUT);
        //imagedestroy($OLD);
		if($degrees!="0"){
        $NEW = imagerotate($NEW, $degrees, 0);
        }
        $IMG = imagegif($NEW);
        imagedestroy($NEW);
        return $IMG;
    }
    FUNCTION marker($IMAGE, $WATERMARK, $MARKER_WHERE="foot"){
        $IMAGEWIDHT = imagesx($IMAGE);
        $IMAGEHEIGHT = imagesy($IMAGE);
        $TMPW = $WATERMARKWIDHT = imagesx($WATERMARK);
        $TMPH = $WATERMARKHEIGHT = imagesy($WATERMARK);
        IF($IMAGEWIDHT < $WATERMARKWIDHT || $IMAGEHEIGHT < $WATERMARKHEIGHT){
            IF($IMAGEWIDHT < $WATERMARKWIDHT){
                $WATERMARKWIDHT = $IMAGEWIDHT;
                $WATERMARKHEIGHT *= $WATERMARKWIDHT / $TMPW;
            } ELSE {
                $WATERMARKHEIGHT = $IMAGEHEIGHT / 2;
                $WATERMARKWIDHT *= $WATERMARKHEIGHT / $TMPH;
            }
            $F = imagecreatetruecolor($WATERMARKWIDHT, $WATERMARKHEIGHT);
            $TRANSPARENCUINDEX = imagecolortransparent($WATERMARK);
            $TRANSPARENCUCOLOR = array('red' => 255, 'green' => 255, 'blue' => 255);
            IF($TRANSPARENCUINDEX >= 0){
                $TRANSPARENCUCOLOR = imagecolorsforindex($WATERMARK, $TRANSPARENCUINDEX);
            }
            $TRANSPARENCUINDEX = imagecolorallocate($F, $TRANSPARENCUCOLOR['red'], $TRANSPARENCUCOLOR['green'], $TRANSPARENCUCOLOR['blue']);
            imagefill($F, 0, 0, $TRANSPARENCUINDEX);
            imagecolortransparent($F, $TRANSPARENCUINDEX);
            imagecopyresampled($F, $WATERMARK, 0, 0, 0, 0, $WATERMARKWIDHT, $WATERMARKHEIGHT, $TMPW, $TMPH);
            $WATERMARK = & $F;
        }
        $NEW = imagecreatetruecolor($IMAGEWIDHT, $IMAGEHEIGHT);
        $FOOTH = $IMAGEHEIGHT - $WATERMARKHEIGHT;
        FOR($J=0; $J<$IMAGEHEIGHT; ++$J){
            FOR($I=0; $I<$IMAGEWIDHT; ++$I){
                $RGB = imagecolorsforindex($IMAGE, imagecolorat($IMAGE, $I, $J));
                IF($MARKER_WHERE==1 && $J < $WATERMARKHEIGHT && $I < $WATERMARKWIDHT){
                    $RGB2 = imagecolorsforindex($WATERMARK, @imagecolorat($WATERMARK, $I, $J));
                    IF($RGB2['alpha']!=127){
                        $RGB['red'] = intval(($RGB['red'] + $RGB2['red']) / 2);
                        $RGB['green'] = intval(($RGB['green'] + $RGB2['green']) / 2);
                        $RGB['blue'] = intval(($RGB['blue'] + $RGB2['blue']) / 2);
                    }
                } ELSEIF($MARKER_WHERE==2 && $J >= $FOOTH && $I < $WATERMARKWIDHT){
                    $RGB2 = imagecolorsforindex($WATERMARK, @imagecolorat($WATERMARK, $I, $J - $FOOTH));
                    IF($RGB2['alpha'] != 127){
                        $RGB['red'] = intval(($RGB['red'] + $RGB2['red']) / 2);
                        $RGB['green'] = intval(($RGB['green'] + $RGB2['green']) / 2);
                        $RGB['blue'] = intval(($RGB['blue'] + $RGB2['blue']) / 2);
                    }
                }
                $IND = imagecolorexact($NEW, $RGB['red'], $RGB['green'], $RGB['blue']);
                IF($IND < 1){
                    $IND = imagecolorallocate($NEW, $RGB['red'], $RGB['green'], $RGB['blue']);
                    IF($IND < 1){
                        $IND = imagecolorclosest($NEW, $RGB['red'], $RGB['green'], $RGB['blue']);
                    }
                }
                imagesetpixel($NEW, $I, $J, $IND);
            }
        }
        return $NEW;
    }
}
?>
