<?php

function makePaymentRequest($checkMerchantId, $price, $cardType) {
    $curl = curl_init();

    $postData = json_encode([
        "checkMerchant" => $checkMerchantId,
        "amount" => $price,
        "totalAmount" => $price,
        "cardType" => $cardType,
        "bonusable" => false
    ]);

    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://pgapi.million.az/payments/payments',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $postData,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
    ]);

    $response = curl_exec($curl);

    if ($response === false) {
        echo 'Curl error: ' . curl_error($curl);
    } else {
        echo 'Response: ' . $response;
    }

    curl_close($curl);
}

// Örnek kullanım:
$checkMerchantId = '380194403951175901'; // Değiştirilecek
$price = 100; // Değiştirilecek
$cardType = 'Visa'; // veya 'Mastercard', değiştirilecek

makePaymentRequest($checkMerchantId, $price, $cardType);
?>
