<?

// Max size PER file in KB
$max_file_size="51200";

// Max size for all files COMBINED in KB
$max_combined_size="204800";

//Maximum file uploades at one time
$file_uploads="5";

//The name of your website
$websitename="Vado.Az";

// Full browser accessable URL to where files are accessed. With trailing slash.
$full_url="http://vado.az/up/";

// Path to store files on your server If this fails use $fullpath below. With trailing slash.
$folder="up/";

// Use random file names? true=yes (recommended), false=use original file name.
// Random names will help prevent files being denied because a file with that name already exists.
$random_name=true;

// Types of files that are acceptiable for uploading. Keep the array structure.
$allow_types=array("jpeg","jpg","gif","png","zip","rar","txt","doc","mp3","3gp","docx","wmv","avi","mp4","aac","mmf","amr","mp2","wav","mkv","mpg","vob","mov","flv","swf","bmp","sql");

// Only use this variable if you wish to use full server paths. Otherwise leave this empty. With trailing slash.
$fullpath="";

//Use this only if you want to password protect your upload form.
$password=""; 

/*
//================================================================================
* ! ATTENTION !
//================================================================================
: Don't edit below this line.
*/

// Initialize variables
$password_hash=md5($password);
$error="";
$success="";
$display_message="";
$file_ext=array();
$password_form="";

// Function to get the extension a file.
function get_ext($key) { 
	$key=strtolower(substr(strrchr($key, "."), 1));
	$key=str_replace("jpeg","jpg",$key);
	return $key;
}

// Filename security cleaning. Do not modify.
function cln_file_name($string) {
	$cln_filename_find=array("/\.[^\.]+$/", "/[^\d\w\s-]/", "/\s\s+/", "/[-]+/", "/[_]+/");
	$cln_filename_repl=array("", ""," ", "-", "_");
	$string=preg_replace($cln_filename_find, $cln_filename_repl, $string);
	return trim($string);
}

// If a password is set, they must login to upload files.
If($password) {
	
	//Verify the credentials.
	If($_POST['verify_password']==true) {
		If(md5($_POST['check_password'])==$password_hash) {
			setcookie("phUploader",$password_hash);
			sleep(1); //seems to help some people.
			header("Location: http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
			exit;
		}
	}

	//Show the authentication form
	If($_COOKIE['phUploader']!=$password_hash) {
		$password_form="<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\">\n";
		$password_form.="<table align=\"center\" class=\"table\">\n";
		$password_form.="<tr>\n";
		$password_form.="<td width=\"100%\" class=\"table_header\" colspan=\"2\">Kod qoyulub</td>\n";
		$password_form.="</tr>\n";
		$password_form.="<tr>\n";
		$password_form.="<td width=\"35%\" class=\"table_body\">Kodu daxil et:</td>\n";
		$password_form.="<td width=\"65%\" class=\"table_body\"><input type=\"password\" name=\"check_password\" /></td>\n";
		$password_form.="</tr>\n";
		$password_form.="<td colspan=\"2\" align=\"center\" class=\"table_body\">\n";
		$password_form.="<input type=\"hidden\" name=\"verify_password\" value=\"true\">\n";
		$password_form.="<input type=\"submit\" value=\" Verify Password \" />\n";
		$password_form.="</td>\n";
		$password_form.="</tr>\n";
		$password_form.="</table>\n";
		$password_form.="</form>\n";
	}
	
} // If Password

// Dont allow submit if $password_form has been populated
If(($_POST['submit']==true) AND ($password_form=="")) {

	//Tally the size of all the files uploaded, check if it's over the ammount.	
	If(array_sum($_FILES['file']['size']) > $max_combined_size*1024) {
		
		$error.="<b>Sehv:</b> Butun fayllar <b>Sebeb:</b> Fayllarin yaddasi choxdur.<br />";
		
	// Loop though, verify and upload files.
	} Else {

		// Loop through all the files.
		For($i=0; $i <= $file_uploads-1; $i++) {
			
			// If a file actually exists in this key
			If($_FILES['file']['name'][$i]) {

				//Get the file extension
				$file_ext[$i]=get_ext($_FILES['file']['name'][$i]);
				
				// Randomize file names
				If($random_name){
					$file_name[$i]=time()+rand(0,100000);
				} Else {
					$file_name[$i]=cln_file_name($_FILES['file']['name'][$i]);
				}
	
				// Check for blank file name
				If(str_replace(" ", "", $file_name[$i])=="") {
					
					$error.= "<b>Sehv:</b> ".$_FILES['file']['name'][$i]." <b>Sebeb:</b> Faylin adi yazilmayib.<br />";
				
				//Check if the file type uploaded is a valid file type. 
				}	ElseIf(!in_array($file_ext[$i], $allow_types)) {
								
					$error.= "<b>Sehv:</b> ".$_FILES['file']['name'][$i]." <b>Sebeb:</b> Sehv fayl tipi.<br />";
								
				//Check the size of each file
				} Elseif($_FILES['file']['size'][$i] > ($max_file_size*1024)) {
					
					$error.= "<b>Sehv:</b> ".$_FILES['file']['name'][$i]." <b>Sebeb:</b> Fayl chox boyukdur.<br />";
					
				// Check if the file already exists on the server..
				} Elseif(file_exists($folder.$file_name[$i].".".$file_ext[$i])) {
	
					$error.= "<b>Sehv:</b> ".$_FILES['file']['name'][$i]." <b>Sebeb:</b> Fayl bazada var.<br />";
					
				} Else {
					
					If(move_uploaded_file($_FILES['file']['tmp_name'][$i],$folder.$file_name[$i].".".$file_ext[$i])) {
						
						$success.="<b>Fayliniz:</b> ".$_FILES['file']['name'][$i]."<br />";
						$success.="<b>URL:</b> <a href=\"".$full_url.$file_name[$i].".".$file_ext[$i]."\" target=\"_blank\">".$full_url.$file_name[$i].".".$file_ext[$i]."</a><br /><br />";
						
					} Else {
						$error.="<b>Sehv:</b> ".$_FILES['file']['name'][$i]." <b>Sebeb:</b> Yuklemelerde sehflik var.<br />";
					}
					
				}
							
			} // If Files
		
		} // For
		
	} // Else Total Size
	
	If(($error=="") AND ($success=="")) {
		$error.="<b>Sehv:</b> Fayl sechilmeyib<br />";
	}

	$display_message=$success.$error;

} // $_POST AND !$password_form

/*
//================================================================================
* Start the form layout
//================================================================================
:- Please know what your doing before editing below. Sorry for the stop and start php.. people requested that I use only html for the form..
*/
define('DOCUMENT_ROOT', dirname(__FILE__).'/');
require "inc/config.php";
require "inc/routes.php";
head();
echo "<div class=\"back\"><div class=\"title\">Upload Sistemi</div>";
If($password_form) {
	
	Echo $password_form;

} Else {
?>
<table class="menu" style="text-align:center;">
<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" enctype="multipart/form-data" name="phuploader">

<tr>
	</tr>
	
	<?If($display_message){?>
	<tr>
		<td colspan="2" class="menum">
		<br />
			<?=$display_message;?>
		<br />
		</td>
	</tr>
	<?}?>
	
	<tr>
	</tr>
	<?For($i=0;$i <= $file_uploads-1;$i++) {?>
		<tr>
			<td class="menu"><b>Se&#231;:</b> 
			<input type="file" name="file[]" size="30" /></td>
		</tr>
	<?}?>
	<tr><hr>
		<td colspan="2" align="center" class="menum">
			<input type="hidden" name="submit" value="true" />
			<input type="submit" value=" Fayl Yüklə " /> &#187; 
			<input type="reset" name="reset" value=" Siyahını Təmizlə " onclick="window.location.reload(true);" />
		</td>
	</tr>

<tr></tr>
</table>
</form>
<?
echo "<div class=\"menu\"><b>Dəstəklənən Formatlar:</b></span> ".implode($allow_types, ", ")."<br />
<b>Max Öl&#231;ü:</b></span> ".$max_file_size."kb.<br />
<b>Max Y&#252;kl&#601;m&#601; H&#601;cmi:</b></span> {$max_combined_size}kb.</div>";
}//Please leave this here.. it really dosen't make people hate you or make your site look bad.. ?>
<?

echo '<div class="link"><a href="index.php">&laquo;- Ana Sehife</a></div>';
echo '</div>';
foot();
?>